function [image,Original]=SwitchDarkFrame(handles,OldFrame,NewFrame)

WaitTics   = 3;
WaitTotal  = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);
%% Get handles
image      = load(fullfile(tempdir,'ShowOrg.mat')).image;
Original   = load(fullfile(tempdir,'Original.mat')).image;
WaitTotal.Send;
Cut        = get(handles.EstimatePhi,'UserData');
if ~isempty(Cut)
    Cut1       = Cut(1);
    Cut2       = Cut(2);
end
Drift      = get(handles.ShowDrift,'UserData');
EnergyRes  = get(handles.Slider, 'SliderStep');
EnergyRes  = EnergyRes(1);

%% Correct Original Image
if isempty(OldFrame)
    OldFrame = zeros([1,1,size(Original,3)]);
end

if isempty(NewFrame)
    NewFrame = zeros([1,1,size(Original,3)]);
end

Original = Original + OldFrame - NewFrame;
WaitTotal.Send;

%% Correct Aligned Image
Drift      =  round(Drift./EnergyRes);

if ~isempty(Drift)
    OldFrame = repmat(OldFrame,[size(image,1),size(image,2),1]);
    NewFrame = repmat(NewFrame,[size(image,1),size(image,2),1]);
    WaitTics   = size(image,1);
    WaitFrame  = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);
    for i=1:size(image,1)
        for j=1:size(image,2)
            OldFrame(i,j,:) = circshift(OldFrame(i,j,:),-Drift(i,j),3);
            NewFrame(i,j,:) = circshift(NewFrame(i,j,:),-Drift(i,j),3);
        end
        WaitFrame.Send;
    end
    WaitFrame.Destroy;
    
    OldFrame = OldFrame(:,:,1+Cut1:end-Cut2);
    NewFrame = NewFrame(:,:,1+Cut1:end-Cut2);
    
    image = image + OldFrame - NewFrame;
else
    image = Original;
end
WaitTotal.Send;
WaitTotal.Destroy;
clearvars -except image Original
end
